
markup.push({

	// MARK: session window

	SessionWindow:
	{
		nsClass: "GXWindow",
		gxWindowTitle: "Session",
		gxCanFullScreen: true,
		gxWindowMaxSize: "3000, 2000",
		gxWindowMinSize: "490, 340",	// this is slightly smaller than layout actually allows (for bottom bar and info panel)
		gxInitialWindowSize: "1030, 560",
		gxInitialWindowPosition: "0.25, 0.75",
		gxBackColor: "BackColor1",
		gxContentView: "SessionWindowContentView",
		gxFullSizeContentView: true,
	},

		
	// MARK: content view

	SessionWindowContentView:
	{
		nsClass: "GXDrawView",
		gxWantsLayer: true,
		gxDenyHitTest: 1,		// deny hit test on self. children can still be hit. let clicks fall through to window, to allow double click for zoom etc
		gxLayout:
		[
			"V:|-0-[titleBar(26)]-0-[graphScrollView]-0-[trialBar]-0-[bottomBar(52)]-0-|",
			"V:|-0-[sidebar]-0-|",

			"H:|-0-[titleBar]-0-[sidebar]-0-|",
			"H:|-0-[graphScrollView]-0-[sidebar]-0-|",
			"H:|-0-[trialBar]-0-[sidebar]-0-|",
			"H:|-0-[bottomBar]-0-[sidebar]-0-|",
			
			"H:[editBtn(125)]-20-[sidebar]",
			"V:[editBtn(19)]-18-[trialBar]",
		],
		gxChildViews:
		{
			titleBar:
			{
				"+": "TitleBarView",
				gxBackPainter:
				{
					nsClass: "GXPainter",
					gxFillColor: "SidebarBackColor1",
					gxFrameColor: "SidebarBackColor2.pressed",
					gxEdgeInsets: "-1, -1, -1, 0",
				},
				gxLayout: [],	// remove inherited layout
			},
			editBtn: {
				"+": "ButtonView.useMarkup.centery.size11.roundEnds",
				gxLayerZPosition: 10,
				gxViewShadow: "{0, 0, 0, 0.4}, {0, 1}, 2.5",
				gxTitle: "Edit Connections",
				axHelp: "Start or stop editing of manual wires. Sockets in the Audio Grid are only available when editing",
			},
			graphScrollView: {
				"+": "GraphScrollView",
			},
			sidebar:
			{
				nsClass: "GXExpandingView",
				axIsIgnored: false,
				axTitle: "Sidebar",
				gxHorizontal: true,
				gxExpandedSize: 320,
				gxBackPainter: {
					nsClass: "GXPainter",
					gxFillColor: "BackColor3",
				},
				gxLayout:
				[
					"V:|-0-[sidebarTabs(60)]",
					"H:|-0-[sidebarTabs(320)]",

					"V:[sidebarTabs]-0-[libraryPanel]-0-|",
					"H:|-0-[libraryPanel(320)]",

					"V:[sidebarTabs]-0-[recordingsPanel]-0-|",
					"H:|-0-[recordingsPanel(320)]",

					"V:[sidebarTabs]-0-[schedulePanel]-0-|",
					"H:|-0-[schedulePanel(320)]",

					"V:[sidebarTabs]-0-[actionsPanel]-0-|",
					"H:|-0-[actionsPanel(320)]",

					"V:[sidebarTabs]-0-[infoPanel]-0-|",
					"H:|-0-[infoPanel(320)]",
				],
				gxChildViews: {
					sidebarTabs: "SidebarTabs",
					libraryPanel: {
						"+": "LibraryPanel",
					},
					recordingsPanel: {		// panel shows according to session recordingsPanelShown, content has its own facemodel
						nsClass: "GXDrawView",
						gxLayerZPosition: 10,
						gxChildViews: {
							recordingsContent: { "+": "RecordingsPanelContent" },
						},
					},
					schedulePanel: {		// panel shows according to session schedulePanelShown, content has its own facemodel
						nsClass: "GXDrawView",
						gxLayerZPosition: 10,
						gxChildViews: {
							scheduleContent: { "+": "SchedulePanel" },
						},
					},
					actionsPanel: {	// panel shows according to session actionsPanelShown, content has its own facemodel
						nsClass: "GXDrawView",
						gxLayerZPosition: 10,
						gxChildViews: {
							actionsContent: { "+": "SessionActionsPanel" },
						},
					},
					infoPanel: {
						"+": "SessionInfoPanel",
					},					
				}
			},
			trialBar: "TrialBarView",
			bottomBar: "SessionBottomBarView",
		}
	},

		
	// MARK: graph view

	GraphScrollView:
	{
		nsClass: "GXScrollView",
		gxBackColor: "SidebarBackColor1",
		gxVScrollbar: "ScrollBarView",
		gxHScrollbar: "ScrollBarView",
		gxCornerFillView: filledView("SidebarBackColor1"),
		gxDocumentView:
		{
			nsClass: "GEGraphView",
			gxViewName: "graphView",
			gxBackPainter: fillPainter("SidebarBackColor1"),
			axIsIgnored: false,
			gxChildViews:
			{
				gridView: {
					nsClass: "GXDrawView",
					gxBackPainter:
					{
						nsClass: "H4GridPainter",
						gxGridColor: "SidebarBackColor1.pressed",
					}
				}
			}
		}
	},

		
	// MARK: - side panel tabs

	SidebarTabs:
	{
		nsClass: "GXDrawView",
		gxViewName: "sidebarTabs",
		axIsIgnored: true,
		//axTitle: "Sidebar tabs",
		axRoleDescription: "tab group",
		gxBackPainter: {
			nsClass: "GXPainter",
			gxEdgeInsets: "-2,-2,-2,0",
			gxFrameColor: "SidebarBackColor2.pressed",
			gxFillColor: "SidebarBackColor2",
		},
		gxLayerZPosition: 10,
		gxLayout: [
			"H:|-16-[libraryTab(==infoTab)]-28-[recordingsTab(==infoTab)]-31-[scheduleTab(==infoTab)]-27-[actionsTab(==infoTab)]-20-[infoTab]-16-|",

			"V:|-10-[libraryTab(27)]-0-[libraryLabel]&alignCenterX",
			"V:|-10-[recordingsTab(27)]-0-[recordingsLabel]&alignCenterX",
			"V:|-10-[scheduleTab(27)]-0-[scheduleLabel]&alignCenterX",
			"V:|-10-[actionsTab(27)]-0-[actionsLabel]&alignCenterX",
			"V:|-10-[infoTab(27)]-0-[infoLabel]&alignCenterX",
		],
		gxChildViews:
		{
			libraryTab: {
				"+": "ImageButtonView.showOn.tab.blocks",
				axTitle: "Blocks",
				gxButtonType: "tab",
				axRoleDescription: "tab, 1 of 5",
				axHelp: "show a library of audio blocks in the sidebar",
			},
			libraryLabel: {
				"+": "TextButtonView.size11",
				gxValueKey: "libraryTabValue",
				gxDefaultDisplayValue: "Blocks",
				gxCanBecomeKeyView: false,
				gxIntrinsicWidth: 40,
				axIsIgnored: true,
			},
			recordingsTab: {
				"+": "ImageButtonView.showOn.tab.recordings",
				axTitle: "Recordings",
				gxButtonType: "tab",
				axRoleDescription: "tab, 2 of 5",
				axHelp: "show recordings for this session in the sidebar",
			},
			recordingsLabel: {
				"+": "TextButtonView.size11",
				gxValueKey: "recordingsTabValue",
				gxDefaultDisplayValue: "Recordings",
				gxIntrinsicWidth: 64,
				gxCanBecomeKeyView: false,
				axIsIgnored: true,
			},
			scheduleTab: {
				"+": "ImageButtonView.showOn.tab.schedule",
				axTitle: "Schedule",
				gxButtonType: "tab",
				axRoleDescription: "tab, 3 of 5",
				axHelp: "show scheduled timers in the sidebar",
			},
			scheduleLabel: {
				"+": "TextButtonView.size11",
				gxValueKey: "scheduleTabValue",
				gxDefaultDisplayValue: "Schedule",
				gxCanBecomeKeyView: false,
				gxIntrinsicWidth: 54,
				axIsIgnored: true,
			},
			actionsTab: {
				"+": "ImageButtonView.showOn.tab.scripts",
				axTitle: "Scripting",
				gxButtonType: "tab",
				axRoleDescription: "tab, 4 of 5",
				axHelp: "show script automations in the sidebar",
			},
			actionsLabel: {
				"+": "TextButtonView.size11",
				gxValueKey: "actionsTabValue",
				gxDefaultDisplayValue: "Scripting",
				gxCanBecomeKeyView: false,
				gxIntrinsicWidth: 64,
				axIsIgnored: true,
			},
			infoTab: {
				"+": "ImageButtonView.showOn.tab.info",
				axTitle: "Info",
				gxButtonType: "tab",
				axRoleDescription: "tab, 5 of 5",
				axHelp: "show session information in the sidebar",
			},
			infoLabel: {
				"+": "TextButtonView.size11",
				gxValueKey: "infoTabValue",
				gxDefaultDisplayValue: "Info",
				gxCanBecomeKeyView: false,
				gxIntrinsicWidth: 30,
				axIsIgnored: true,
			},
		}
	},

		
	// MARK: - library panel

	LibraryPanel:
	{
		nsClass: "GXDrawView",
		axIsIgnored: true,
		//axTitle: "Block Library",
		gxLayout:
		[
			"V:|-0-[libraryFilter]-0-[libraryScrollView]-0-|",
			//"V:|-0-[libraryScrollView]-0-|",
			"H:|-0-[libraryScrollView]-0-|",
		],
		gxChildViews:
		{
			libraryScrollView:
			{
				nsClass: "GXScrollView",
				gxBackColor: "SidebarBackColor2",
				gxVScrollbar: "ScrollBarView",
				gxDocumentView: "LibraryRootList"
			},
			libraryFilter:
			{
				nsClass: "GXDrawView",
				gxBackPainter: {
					nsClass: "GXPainter",
					gxEdgeInsets: "0,-2,-2,-2",
					//gxFrameColor: "BackColor2",
					gxFillColor: "SidebarBackColor2",
				},
				gxLayout: [
					"H:|-0-[self]-0-|",
					"V:|-10-[filterText(23)]-7-|",
					"H:|-14-[filterText]-20-|",
				],
				gxChildViews:
				{
					//label: labelView("Filter:"),
					filterText: {
						"+": "DarkTextField",
						gxValueKey: "filterText",
						gxPlaceholderString: "Filter",
						gxNilWhenEmpty: true,
						axIsIgnored: false,
						axTitle: "Search",
						axHelp: "Search the block library",
						gxEdgeInsets: "7, 3, 2, 2",
						gxBaselineOffset: 6,
						gxBackPainter:
						{
							"+": "ControlBack.noPressed",
							gxCornerRadius: 999,
						},
						gxButtonForePainter: {
							"+": "ImagePainter.iconSize18.foreColor2.editclear",
							gxEdgeInsets: "0, 1, 5, 1",
						},
					},
				}
			}
		}
	},

		
	// MARK: info panel

	SessionInfoPanel:
	{
		nsClass: "GXDrawView",
		axIsIgnored: true,
		//axTitle: "Session Info",
		gxBackPainter: {
			nsClass: "GXPainter",
			gxFillColor: "SidebarBackColor2",
		},
		gxLayout:
		[
			"V:|-12-[titleLabel]-4-[title(26)]-10-[notesLabel]-4-[notesBezel]-14-[divider1(1)]-9-[settingsLabel]-8-[autoWires]",
			
			// this is controlling the minimum window size
			// notes view compresses and expands (up to a point, 300px)
			// lowest control (sample rate menu), stays in view,
			// but sticks below notes at larger window sizes.
			"V:[notesBezel(>=36)]",
			"V:[notesBezel(<=300@490)]",
			"V:[rateMenu]-(>=16)-|",
			"V:[rateMenu]-(16@480)-|",
			
			"H:|-14-[titleLabel]",
			"H:|-14-[title]-14-|",
			
			"H:|-14-[notesLabel]",
			"H:|-14-[notesBezel]-14-|",

			"V:[autoWires]-12-[autoStart]",
			"V:[autoStart]-13-[rateMenu]&alignLeft",

			"H:|-0-[divider1]-0-|",
			"H:|-14-[settingsLabel]",
			
			"H:[autoWiresLabel]-8-[autoWires(52)]-75-|&alignBaseline",
			"H:[autoStartLabel]-8-[autoStart]-75-|&alignBaseline",
			"H:|-30-[rateMenuLabel]-8-[rateMenu]-75-|&alignBaseline",
		],
		gxChildViews:
		{
			titleLabel: labelView("Session Title:"),
			title: {
				"+": "DarkTextField",
				gxNilWhenEmpty: true,
				gxDisableOnNil: false,
				gxValueKey: "name",
				axTitle: "Session Title",
				axHelp: "Edits the name of this session",
			},
			notesLabel: labelView("Notes:"),
			notesBezel:
			{
				nsClass: "GXDrawView",
				gxBackPainter: "ControlBack",
				gxLayout:
				[
					"H:|-1-[notesScrollView]-1-|",
					"V:|-5-[notesScrollView]-5-|",
				],
				gxChildViews:
				{
					notesScrollView:
					{
						nsClass: "GXScrollView",
						gxBackColor: "BackColor3",
						gxVScrollbar: "ScrollBarView",
						gxDocumentView: {
							"+": "DarkTextField",
							nsClass: "GXTextView",
							gxViewName: "notesView",
							gxTextContainerInset: "0, 0",
							gxFrameRect: "0, 0, 274, 100",    // frame rect required. width is critical!
							axTitle: "Notes",
							axHelp: "A place to make notes for this session",
							gxValueKey: "sessionDescription",
						}
					},
				}
			},
			divider1: filledView("BackColor3"),
			settingsLabel: labelView("Settings", "mediumWeight.foreColor1"),
			autoWires: {
				"+": "SwitchView",
				gxBaselineOffset: 7,
				axTitle: "Automatic Connections",
				axHelp: "When on, blocks are wired together automatically. When off, wires are created manually between sockets that appear in the audio grid",
			},
			autoWiresLabel: labelView("Automatic Connections:", "right"),
			autoStart: {
				"+": "PopupMenuTemplate",
				gxValueKey: "autoStart",
				axTitle: "Auto Run this session",
				gxMenuItems:
				[
					menuItem("Off", 0),
					menuItem("On Launch", 1),
					//menuItem("At Login", 2),
				],
			},
			autoStartLabel: labelView("Auto Run:", "right"),
			rateMenu: {
				"+": "PopupMenuTemplate",
				gxMenuItemsKeyPath: "rateMenuItems",
				gxHideOnNilValue: false,
				gxDisableOnKey: "running",
				axTitle: "Session Sample Rate",
				axHelp: "All blocks in the session will be run at this rate",
			},
			rateMenuLabel: labelView("Sample Rate:", "right"),
		},
	},

	// MARK: recordings panel

	RecordingsPanelContent:
	{
		nsClass: "GXDrawView",
		gxModelKeyPath: "filesFaceModel",	// our own face model
		gxLayout:
		[
			"V:|-0-[self]-0-|",
			"H:|-0-[self]-0-|",
			"V:|-0-[recordingsScrollView]-0-[recordingsActions(53)]-0-|",
			"H:|-0-[recordingsScrollView]-0-|",
			"H:|-0-[recordingsActions]-0-|",
		],
		gxChildViews:
		{
			recordingsScrollView:
			{
				nsClass: "GXScrollView",
				gxBackColor: "SidebarBackColor2",
				gxVScrollbar: "ScrollBarView",
				gxDocumentView:
				{
					nsClass: "GXListView",
					gxViewName: "recordingsList",
					gxListItemView: "RecordedFileView",
					axIsIgnored: false,
					axTitle: "Recordings List",
					gxTopHeight: 12,
					gxItemHeight: 60,
					gxInterItemHeight: 10,
					gxBottomHeight: 12,
					gxLayout: "H:|-0-[self]-0-|"
				},
			},
			recordingsActions:
			{
				nsClass: "GXDrawView",
				gxBackPainter: {
					nsClass: "GXPainter",
					gxEdgeInsets: "0, 0, -2, -2",
					gxFrameColor: "SidebarBackColor2.pressed",
					gxFillColor: "SidebarBackColor2",
				},
				gxLayout: [
					"V:|-15-[actionsMenu]",
					"H:|-16-[inspectBtn(95)]-15-[actionsMenu(102)]&alignCenterY",
				],
				gxChildViews:
				{
					inspectBtn: {
						"+": "ButtonView.useMarkup",
						gxTitle: "<icon.action.help/> Inspect",
						axHelp: "Opens the Inspector window for a selected recording",
						gxIntrinsicHeight: 22,
					},
					actionsMenu: {
						"+": "PopupMenuView.useMarkup",
						gxHideOnNilValue:false,
						gxPullsDown: true,
						gxTitle: "<icon.action.menu/> Actions",
						gxIntrinsicHeight: 22,
						axTitle: "File Actions",
						axHelp: "Actions for selected recordings. Each recording also has a context menu",
						gxMenuItemsKeyPath: "actionMenuItems",
					},
				},
			},
			emptyView: {
				nsClass: "GXDrawView",
				gxForePainter: "ImagePainter.top.foreColor3.empty-file",
				gxShowOnKey: "recordingsListIsEmpty",
				axIsIgnored: false,
				axDescription: "No Recordings Yet, Recordings made with this session will be listed here",
				gxLayerZPosition: 10,
				gxLayout: [
					"H:[superview]-(<=0)-[self(240)]&alignCenterY",
					"V:[superview]-(<=0)-[self(220)]&alignCenterX",
					"H:|-0-[label]-0-|",
					"V:[label(60)]-80-|",
				],
				gxChildViews: {
					label: labelView("<mediumWeight>No Recordings Yet</mediumWeight><size4>\n\n</size4><size12>Recordings made with this session\nwill display here.", "foreColor3.useMarkup.wrap.centerx.size15"),
				},
			},
		},
	},

		
	// MARK: schedule panel

	SchedulePanel:
	{
		nsClass: "GXDrawView",
		gxModelKeyPath: "timersFaceModel",	// our own face model
		axIsIgnored: true,
		gxLayout:
		[
			"V:|-0-[self]-0-|",
			"H:|-0-[self]-0-|",
			"V:|-0-[timersScrollView]-0-[actionButtons(53)]-0-|",
			"H:|-0-[timersScrollView]-0-|",
			"H:|-0-[actionButtons]-0-|",
		],
		gxChildViews:
		{
			timersScrollView: {
				nsClass: "GXScrollView",
				gxBackColor: "SidebarBackColor2",
				gxVScrollbar: "ScrollBarView",
				gxDocumentView:
				{
					gxViewName: "timerList",
					nsClass: "GXListView",
					gxListItemView: "TimerView",
					gxTopHeight: 12,
					gxItemHeight: 60,
					gxInterItemHeight: 10,
					gxBottomHeight: 12,
					axIsIgnored: false,
					axTitle: "Schedule List",
					gxLayout: "H:|-0-[self]-0-|"
				},
			},
			actionButtons: {
				nsClass: "GXDrawView",
				gxBackPainter: {
					nsClass: "GXPainter",
					gxEdgeInsets: "0, 0, -2, -2",
					gxFrameColor: "SidebarBackColor2.pressed",
					gxFillColor: "SidebarBackColor2",
				},
				gxLayout: [
					"V:|-14-[addTimerBtn]",
					"H:|-16-[addTimerBtn(96)]-(>=14)-[deleteTimerBtn(24)]-16-|&alignBaseline",
				],
				gxChildViews:
				{
					addTimerBtn: {
						"+": "PlusButton",
						gxTitle: "<plusButton/> New Timer",
					},
					deleteTimerBtn: {
						"+": "MinusButton",
						gxTitle: "<minusButton/>",
						axTitle: "Delete selected Timers",
					},
				}
			},
			emptyView: {
				nsClass: "GXDrawView",
				gxForePainter: "ImagePainter.top.foreColor3.empty-timers",
				gxShowOnKey: "timerListEmpty",
				axIsIgnored: false,
				axDescription: "No Timers Yet. Click on New Timer below to get started.",
				gxLayerZPosition: 10,
				gxLayout: [
					"H:[superview]-(<=0)-[self(240)]&alignCenterY",
					"V:[superview]-(<=0)-[self(220)]&alignCenterX",
					"H:|-0-[label]-0-|",
					"V:[label(60)]-80-|",
				],
				gxChildViews: {
					label: labelView("<mediumWeight>No Timers Yet</mediumWeight><size4>\n\n</size4><size12>Click on <boldWeight>“New Timer”</boldWeight> below\nto get started.", "foreColor3.useMarkup.wrap.centerx.size15"),
				},
			},
		},
	},

	
	// MARK: automations panel

	SessionActionsPanel:
	{
		nsClass: "GXDrawView",
		axIsIgnored: true,
		gxModelKeyPath: "automationsFaceModel",	// our own face model
		axTitle: "Automations",
		gxBackPainter: {
			nsClass: "GXPainter",
			gxFillColor: "SidebarBackColor2",
		},
		gxLayout:
		[
			"H:|-0-[self]-0-|",
			"V:|-0-[self]-0-|",
			"V:|-0-[actionsScrollView]-0-[automationButtons(53)]-0-|",
			"H:|-0-[actionsScrollView]-0-|",
			"H:|-0-[automationButtons]-0-|",
		],
		gxChildViews:
		{
			actionsScrollView: {
				nsClass: "GXScrollView",
				gxBackColor: "SidebarBackColor2",
				gxVScrollbar: "ScrollBarView",
				gxDocumentView:
				{
					gxViewName: "automationList",
					nsClass: "GXListView",
					gxCopyValues: true,
					gxListItemView: "AutomationListItem",
					gxTopHeight: 12,
					gxItemHeight: 82,
					gxInterItemHeight: 10,
					gxBottomHeight: 12,
					axIsIgnored: false,
					axTitle: "Automations List",
					gxLayout: "H:|-0-[self]-0-|"
				},
			},
			automationButtons:
			{
				nsClass: "GXDrawView",
				gxBackPainter: {
					nsClass: "GXPainter",
					gxEdgeInsets: "0, 0, -2, -2",
					gxFrameColor: "SidebarBackColor2.pressed",
					gxFillColor: "SidebarBackColor2",
				},
				gxLayout: [
					"V:|-14-[addAutomationBtn]",
					"H:|-16-[addAutomationBtn(130)]-(>=12)-[deleteAutomationBtn(24)]-16-|&alignBaseline",
				],
				gxChildViews:
				{
					addAutomationBtn: {
						"+": "PlusButton",
						gxTitle: "<plusButton/> New Automation",
					},
					deleteAutomationBtn: {
						"+": "MinusButton",
						axTitle: "Delete",
						axDescription: "Delete selected automations",
					},
				}
			},
			emptyView: {
				nsClass: "GXDrawView",
				gxForePainter: "ImagePainter.top.foreColor3.empty-actions",
				gxShowOnKey: "automationListEmpty",
				axIsIgnored: false,
				axDescription: "No Automations Yet. Click on New Automation below to get started.",
				gxLayerZPosition: 10,
				gxLayout: [
					"H:[superview]-(<=0)-[self(240)]&alignCenterY",
					"V:[superview]-(<=0)-[self(220)]&alignCenterX",
					// image is 84*78. text ~200 wide
					"H:|-0-[label]-0-|",
					"V:[label(60)]-80-|",
				],
				gxChildViews: {
					label: labelView("<mediumWeight>No Automations Yet</mediumWeight><size4>\n\n</size4><size12>Click on <boldWeight>“New Automation”</boldWeight> below\nto get started.", "foreColor3.useMarkup.wrap.centerx.size15"),
				},
			},
		},
	},
	

	// MARK: - run button

	RunButton:
	{
		nsClass: "GXButtonView",
		gxBackPainter: {
			"+": "ControlBack.noOn",
			gxFillColor: "ColorThemeLive1",
		},
		gxForePainter: "LabelFore.foreColorTheme1.withOn",
		gxToolTip: "Start this session",
		gxOnToolTip: "Stop the session",
		axHelp: "Starts or Stops the session",
	},

	// MARK: bottom bar

	SessionBottomBarView:
	{
		nsClass: "GXDrawView",
		gxViewName: "bottomBar",
		gxBackPainter: fillPainter("LCDBackColor2"),
		//gxCanDrawSubviewsIntoLayer: true,
		gxLayerZPosition: 10,
		gxIntrinsicWidth: -1,	 // resizes with window
		gxLayout:
		[
			"H:|-0-[main(>=100)]-0-|",
			"V:|-1-[main(50)]"
		],
		gxChildViews:
		{
			main:
			{
				nsClass: "GXDrawView",
				gxIntrinsicWidth: -1,	 // resizes with window
				gxLayout:
				[
					"H:|-20-[runBtn(70)]-2-[time(113)]-14-[meterHostView]-8-[spinnerHost(23)]-5-[sessionStatus(100)]-4-[sampleRate(56)]-(>=14)-[sidebarBtn(50)]-30-|",
					"H:[sideBarBtnAnim(50)]-30-|",

					// meters want to fill space up to a point, use priorities to make want to be wide, but not too wide,
					// and not just collapsing to zero like it doesn't care
					"H:[meterHostView(<=996@700)]",	// fits some number of stripes
					"H:[meterHostView(>=2000@400)]",
					
					"V:|-12-[runBtn(25)]",
					"V:|-7-[time(34)]",
					"V:|-3-[meterHostView(42)]",
					"V:|-13-[spinnerHost(23)]",
					"V:|-7-[sessionStatus(34)]",
					"V:|-9-[sampleRate(34)]",

					"V:|-6-[sidebarBtn(24)]-0-[sidebarBtnLabel]&alignCenterX",
					"V:|-6-[sideBarBtnAnim(24)]",
				],
				gxChildViews:
				{
					runBtn: {
						"+": "RunButton.size14.noLightMode",
					},
					spinnerHost: {
						nsClass: "GXLayerHostingView",
						gxRootLayer:
						{
							nsClass: "GXCaarLayer",
							gxViewName: "spinner",
							gxAnimateOnKey: "running",
							//gxHideOnNilValue: true,
							gxAnimationDivider: 2,
							gxCaarPainter: "RecordingSpinnerPainter.noLightMode",
							gxTransition: {
								nsClass: "GXSpinnerTransition",
								gxDuration: 1.0,
								gxRunOn: 1.0,
							},
						}
					},
					sessionStatus: {
						"+": "LabelView.left.foreColor1.withLive.noLightMode.size15.mediumWeight",
						gxIntrinsicWidth: -1,	 // resizes with window
						axTitle: "Status",
						axIsIgnored: false
					},
					time: {
						"+": "LabelView.right.foreColor1.withLive.noLightMode.mediumWeight.size18",
						gxValueKey: "graph.graphTime",
						gxAnimateOnKey: "graph.started",
						gxFormatter: { nsClass:"GXTimeFormatter", showDays:true },
						axTitle: "Session time",
						axIsIgnored: false
					},
					meterHostView: {
						nsClass: "GXLayerHostingView",
						gxLayerZPosition: 2,
						gxRootLayer:
						{
							nsClass: "AH4SpecMeterLayer",
							gxValueKey: "specData",
							gxAnimateOnKey: "graph.started",
							gxAnimationDivider: 2,
							gxForePainter: {
								nsClass: "GXPainter",
								gxFillColor: "ColorThemeLive2.noLightMode",
							},
						}
					},
					sampleRate: {
						"+": "LabelView.centerxy.disabled.size10",
						axTitle: "Session Sample Rate",
						axIsIgnored: false
					},
					sidebarBtn: {
						"+": "ImageButtonView",
						gxValueKey: "sidebarValue",
						axIsIgnored: true,
					},
					sideBarBtnAnim:
					{
						nsClass: "GXLayerHostingView",
						axIsIgnored: true,
						gxRootLayer:
						{
							nsClass: "GXCaarLayer",
							gxViewName: "sidebarBtn",	// same as the button, same value accessor
							gxValueKey: "sidebarValue",
							gxCaarPainter: {
								nsClass: "GXCaarPainter",
								gxAsset: "sidebartoggle",
								gxAssetDuration: 1.0,
								gxTintColor: "ForeColor1.noLightMode",
							},
							gxTransition: {
								nsClass: "GXUnitTransition",
								gxDuration: 0.5,
								
								//gxStartDelay: 0.05,	// start as sidebar finishes slide open or closed
							},
						}
					},
					sidebarBtnLabel: {
						"+": "TextButtonView.noOn.noLightMode.size11",
						gxValueKey: "sidebarValue",
						gxDisplayValueKey: "sidebarBtnLabelValue",
						axIsIgnored: false,
						axHelp: "Hide or Show the Sidebar",
						gxIntrinsicWidth: 80,
					}
				}
			}
		}
	},
		

})




